 # -*- coding: utf-8 -*-
import utils
from variables import*


###############################################################################
#                                                                        FULL BACK UP AND SPECIAL CONVERT
###############################################################################

def BackUp(folder, title):

    if backupPath == '':
        dialog.ok(addonTitle, 'No path set for backup location', '', 'Please set path in settings and try again')
        addon.openSettings()
    else:
        backup_zip = xbmc.translatePath(os.path.join(backupPath,title+'.zip'))

        if  title == 'setup':
            utils.ConvertPaths(home)
        ArchiveTree(folder, backup_zip, title, backupheader, backupinfo1, backupinfo2, backupinfo3, backupignoreDirs, backupignoreFiles)
        time.sleep(1)

        dialog.ok(addonTitle, '%s Backup was [COLOR fffea800][B]SUCCESSFUL[/B][/COLOR]!'% title)


###############################################################################
#                                                                        ARCHIVE TREE
###############################################################################

def ArchiveTree(sourcefile, destfile, name, backupheader, backupinfo1, backupinfo2, backupinfo3, backupignoreDirs, backupignoreFiles):

    backupZip = zipfile.ZipFile(destfile , 'w', zipfile.ZIP_DEFLATED)
    rootlen = len(sourcefile)
    for_progress = []
    item =[]
    dialogProgress.create(backupheader, backupinfo1, backupinfo2, backupinfo3)

    for base, dirs, files in os.walk(sourcefile):
        for file in files:
            item.append(file)

    itemNumber =len(item)

    for base, dirs, files in os.walk(sourcefile):
        dirs[:] = [d for d in dirs if d not in backupignoreDirs]
        files[:] = [f for f in files if f not in backupignoreFiles]

        for file in files:
            for_progress.append(file)
            progress = len(for_progress) / float(itemNumber) * 100
            dialogProgress.update(int(progress),"Backing Up Files",'[COLOR fffea800]%s[/COLOR]'%file, 'Please Wait')
            fn = os.path.join(base, file)

            if not 'temp' in dirs:
                if not addon_ID in dirs:
                   import time
                   force= '01/01/1980'
                   fileDate = time.strftime('%d/%m/%Y', time.gmtime(os.path.getmtime(fn)))

                   if fileDate > force:
                       backupZip.write(fn, fn[rootlen:])

    if itemNumber == 0:
        backupZip.write(sourcefile, name)

    backupZip.close()
    dialogProgress.close()

