import main
from variables import*

###############################################################################
#						                                                  PERCENTAGE
###############################################################################
	
def percentage(part, whole):
	return 100 * float(part)/float(whole)

###############################################################################
#						                                                       NOTIFY
###############################################################################

def notify(title,message,times=2000,icon=icon):
	xbmc.executebuiltin('XBMC.Notification(%s, %s, %s, %s)' % (title , message , times, icon))


###############################################################################
#						                                          FORCE REPO UPDATES
###############################################################################

def forceUpdate():
	xbmc.executebuiltin('UpdateAddonRepos()')
	notify(addonTitle, 'Checking Addon Updates')

def addonCheck(name):
    if xbmc.getCondVisibility('System.HasAddon(%s)' % name):
        return True



###############################################################################
#						                                                      CHECK URL
###############################################################################
 
def checkUrl(url):
	if url == 'http://': return False
	try: 
		req = urllib2.Request(url)
		response = urllib2.urlopen(req)
		response.close()
	except Exception, e:
		return e
	return True

###############################################################################
#						                                                         OPEN URL
###############################################################################
 
def openURL(url, note=None):
	if not checkUrl(url) == True: 
	    if note:
	        notify(addonTitle, '%s not available' % note); return ''
	    else: return ''
	req = urllib2.Request(url)
	req.add_header('User-Agent', 'Mozilla/5.0 (Windows; U; Windows NT 5.1; en-GB; rv:1.9.0.3) Gecko/2008092417 Firefox/3.0.3')
	response = urllib2.urlopen(req)
	link=response.read()
	response.close()
	return link

###############################################################################
#						                                                      LOG WINDOW
###############################################################################


def TextBoxes(announce):

	class window():

		def __init__(self,*args,**kwargs):

			xbmc.executebuiltin("ActivateWindow(10147)")
			self.win=xbmcgui.Window(10147)
			xbmc.sleep(500)
			self.setControls()

		def setControls(self):

			self.win.getControl(1).setLabel(addonTitle)
			try: f=open(announce); text=f.read()
			except: text=announce
			self.win.getControl(5).setText(str(text))
			return

	window()
	while xbmc.getCondVisibility('Window.IsVisible(10147)'):
		time.sleep(.5)
	import errors
	errors.logs()

## ################################################## ##
## ################################################## ##

class startup(xbmcgui.WindowDialog):
	scr={}; scr['L']=0; scr['T']=0; scr['W']=1280; scr['H']=720; 
	def __init__(self,force=None,noteType='t',noteMessage='',noteImage='', L=140,T=110,W=1000,H=500,Font='font14',TxtColor='FFFFFFFF'):
		if len(noteImage)==0: noteImage=DefaultNoteImage
		noteType='t'
		
		self.noteType=noteType; self.noteMessage=noteMessage; self.noteImage=noteImage; self.Font=Font; self.TxtColor=TxtColor; 
		## ### ## 
		self.background=DefaultNoteImage; #artp('black1'); 
		self.BG=xbmcgui.ControlImage(L,T,W,H,self.background,aspectRatio=0); 

		iLogoW=144; iLogoH=68; 

		L2=200; T2=200; W2=880; H2=340; 
		L3=L2+5; T3=T2+60; W3=W2-18; H3=H2-5-60; 
		
		self.TxtMessage=xbmcgui.ControlTextBox(L2+5,T2,W2-10,H2,font=self.Font,textColor=self.TxtColor); 

		w1=140; h1=60; w2=140; h2=60; spacing1=20; 
		l2=L+W-spacing1-w2; t2=T+H-h2-spacing1; 
		l1=L+W-spacing1-w2-spacing1-w1; t1=T+H-h1-spacing1;
		self.buttonContinue=xbmcgui.ControlButton(l2,t2,w2,h2,"Continue",textColor="0xffffffff",focusedColor="0xFF191970",alignment=6,focusTexture=focus,noFocusTexture=nofocus);
		self.buttonDownload=xbmcgui.ControlButton(l1,t1,w1,h1,"Download",textColor="0xffffffff",focusedColor="0xFF191970",alignment=6,focusTexture=focus,noFocusTexture=nofocus);
		self.buttonForce=xbmcgui.ControlButton(l1,t1,w1,h1,"Force",textColor="0xffffffff",focusedColor="0xFF191970",alignment=6,focusTexture=focus,noFocusTexture=nofocus); 


		if force:
		 

		    for z in [self.BG,self.TxtMessage,self.buttonContinue,self.buttonForce]: self.addControl(z); 

		    self.buttonContinue.controlLeft(self.buttonForce); self.buttonContinue.controlRight(self.buttonForce); 
		    self.buttonForce.controlLeft(self.buttonContinue); self.buttonForce.controlRight(self.buttonContinue);
		else:
		    for z in [self.BG,self.TxtMessage,self.buttonContinue]: self.addControl(z);
		    self.buttonContinue.controlLeft(self.buttonContinue); self.buttonContinue.controlRight(self.buttonContinue); 
		
		self.setFocus(self.buttonContinue); 	
		self.TxtMessage.setText(self.noteMessage); 
		
	def ContinuePressed(self):
		self.close()
		main.menu()

	def forcePressed(self):
		forceUpdate()
		

	def onControl(self,control):
		if   control==self.buttonContinue: self.ContinuePressed()
		elif   control==self.buttonForce: self.forcePressed()
		else:
			try:
				self.setFocus(self.doWizard); 
			except: pass

###############################################################################
#						                                             SKIN SWITCHER GET OLD
###############################################################################

def getOld(old):

	try:
		old = '"%s"' % old 
		query = '{"jsonrpc":"2.0", "method":"Settings.GetSettingValue","params":{"setting":%s}, "id":1}' % (old)
		response = xbmc.executeJSONRPC(query)
		response = simplejson.loads(response)

		if response.has_key('result'):
			if response['result'].has_key('value'):
				return response ['result']['value'] 

	except:
		pass

	return None

###############################################################################
#						                                             SKIN SWITCHER SET NEW
###############################################################################

def setNew(new, value):

	try:
		new = '"%s"' % new
		value = '"%s"' % value
		query = '{"jsonrpc":"2.0", "method":"Settings.SetSettingValue","params":{"setting":%s,"value":%s}, "id":1}' % (new, value)
		response = xbmc.executeJSONRPC(query)

	except:
		pass

	return None

###############################################################################
#						                                                  SKIN SWITCHER
###############################################################################

def swapSkins(skin):

	old = 'lookandfeel.skin'
	value = skin
	current = getOld(old)
	new = old
	setNew(new, value)


###############################################################################
#						                                                  DOWNLOADER
###############################################################################

def download(url, dest, dialogProgress = None):

    if not dialogProgress:
        dialogProgress.create(addonTitle,"Downloading Content",' ', ' ')

    dialogProgress.update(0)
    start_time=time.time()
    urllib.urlretrieve(url, dest, lambda nb, bs, fs: downloadProgress(nb, bs, fs, dialogProgress, start_time))

###############################################################################
#						                                              DOWNLOADER PROGRESS
###############################################################################
     
def downloadProgress(numblocks, blocksize, filesize, dialogProgress, start_time):

        try: 
            percent = min(numblocks * blocksize * 100 / filesize, 100) 
            currently_downloaded = float(numblocks) * blocksize / (1024 * 1024) 
            kbps_speed = numblocks * blocksize / (time.time() - start_time) 

            if kbps_speed > 0 and not percent == 100: 
                eta = (filesize - numblocks * blocksize) / kbps_speed 
            else: 
                eta = 0

            kbps_speed = kbps_speed / 1024 
            total = float(filesize) / (1024 * 1024) 
            mbs = '%.02f MB of %.02f MB' % (currently_downloaded, total) 
            e = 'Speed: %.02f Kb/s ' % kbps_speed 
            e += 'ETA: %02d:%02d' % divmod(eta, 60) 
            dialogProgress.update(percent, mbs, e)

        except: 
            percent = 100 
            dialogProgress.update(percent) 

        if dialogProgress.iscanceled():
            dialogProgress.close()

###############################################################################
#						                                                     EXTRACTOR
###############################################################################

def extractAll(_in, _out, dialogProgress):

	zin = zipfile.ZipFile(_in,  'r')
	nFiles = float(len(zin.namelist()))
	count = 0; errors = 0; error = '';
	zipit = str(_in).replace('\\', '/').split('/'); zname = zipit[len(zipit)-1].replace('.zip', '')

	try:

		for item in zin.infolist():
			count += 1; update = int(count / nFiles * 100);
			file = str(item.filename).split('/')
			dialogProgress.update(update, 'Installing update: (Errors: %s)' % (errors),'[COLOR fffea800]%s[/COLOR]' % item.filename)

			try:
				zin.extract(item, _out)

			except Exception, e:
				errors += 1; error += '%s\n' % e

	except Exception, e:
		errors += 1; error += '%s\n' % e

	if dialogProgress.iscanceled():
		dialogProgress.close()

	return '%d/%d/%s' % (update, errors, error)
	
###############################################################################
#						                                                  CONVERT TO SPECIAL
###############################################################################

def ConvertPaths(url):

    dialogProgress.create(addonTitle,"Renaming paths to special://",'', 'Please Wait')

    for root, dirs, files in os.walk(url):
        for file in files:

            if file.endswith(".xml"):
                 dialogProgress.update(0,"Converting",file, 'Please Wait')
                 a=open((os.path.join(root, file))).read()
                 b=a.replace(userData, 'special://profile/').replace(addons,'special://home/addons/') 
                 f = open((os.path.join(root, file)), mode='w')
                 f.write(str(b))
                 f.close()

    dialog.ok(addonTitle, "All file paths converted to special://",'Please press ok to continue')

def enable17():
    if installedKodi > '17':
        getDB = database.connect(addons27)
        listAddons = os.listdir(addons)
        getDB.executemany('update installed set enabled=1 WHERE addonID = (?)', ((name,) for name in listAddons))
        getDB.commit()
        xbmc.executebuiltin("XBMC.UpdateLocalAddons()")
        notify(addonTitle, 'Enabling all addons')  
    else:
        pass