import os, xbmc, xbmcaddon

#########################################################
### User Edit Variables #################################
#########################################################
ADDON_ID       = xbmcaddon.Addon().getAddonInfo('id')
ADDONTITLE     = 'Stream Life Wizard'
EXCLUDES       = [ADDON_ID, 'plugin.program.streamlifegowizard', 'repository.streamlifegorepo']
# Text File with build info in it.
BUILDFILE      = 'http://streamlife.xyz/go/w1zard/Go_Android_Wizard/builds.txt'
# How often you would list it to check for build updates in days
# 0 being every startup of kodi
UPDATECHECK    = 2
# Text File with apk info in it.
APKFILE        = 'http://streamlife.xyz/go/w1zard/Go_Android_Wizard/apks.txt'
# Text File with Youtube Videos urls.  Leave as 'http://' to ignore
YOUTUBETITLE   = 'Stream Life Guides & Tutorials'
YOUTUBEFILE    = 'http://streamlife.xyz/go/w1zard/Go_Android_Wizard/youtube.txt'
# Text File for addon installer.  Leave as 'http://' to ignore
ADDONFILE      = 'http://streamlife.xyz/go/w1zard/Go_Android_Wizard/addons.txt'
# Text File for advanced settings.  Leave as 'http://' to ignore
ADVANCEDFILE   = 'http://'

# Dont need to edit just here for icons stored locally
PATH           = xbmcaddon.Addon().getAddonInfo('path')
ART            = os.path.join(PATH, 'resources', 'art')

#########################################################
### THEMING MENU ITEMS ##################################
#########################################################
# If you want to use locally stored icons the place them in the Resources/Art/
# folder of the wizard then use os.path.join(ART, 'imagename.png')
# do not place quotes around os.path.join
# Example:  ICONMAINT     = os.path.join(ART, 'mainticon.png')
#           ICONSETTINGS  = 'http://aftermathwizard.net/repo/wizard/settings.png'
# Leave as http:// for default icon
ICONBUILDS     = 'http://streamlife.xyz/go/w1zard/Go_Android_Wizard/Images/Builds_Icon_256.png'
ICONMAINT      = 'http://streamlife.xyz/go/w1zard/Go_Android_Wizard/Images/Maintenance_Icon_256.png'
ICONAPK        = 'http://streamlife.xyz/go/w1zard/Go_Android_Wizard/Images/Android_APK_Installer_Icon_256.png'
ICONADDONS     = 'http://streamlife.xyz/go/w1zard/Go_Android_Wizard/Images/Addon_Installer_Icon_256.png'
ICONYOUTUBE    = 'http://streamlife.xyz/go/w1zard/Go_Android_Wizard/Images/YouTube_Icon_256.png'
ICONSAVE       = 'http://streamlife.xyz/go/w1zard/Go_Android_Wizard/Images/Save_Data_Icon_256.png'
ICONTRAKT      = 'http://streamlife.xyz/go/w1zard/Go_Android_Wizard/Images/Trakt_Icon_256.png'
ICONREAL       = 'http://streamlife.xyz/go/w1zard/Go_Android_Wizard/Images/RealDebrid_Icon_256.png'
ICONLOGIN      = 'http://streamlife.xyz/go/w1zard/Go_Android_Wizard/Images/Login_Icon_256.png'
ICONCONTACT    = 'http://streamlife.xyz/go/w1zard/Go_Android_Wizard/Images/Contact_Icon_256.png'
ICONSETTINGS   = 'http://streamlife.xyz/go/w1zard/Go_Android_Wizard/Images/Settings_Icon_256.png'
# Hide the ====== seperators 'Yes' or 'No'
HIDESPACERS    = 'Yes'
# Character used in seperator
SPACER         = '-'

# You can edit these however you want, just make sure that you have a %s in each of the
# THEME's so it grabs the text from the menu item
COLOR1         = 'blueviolet'
COLOR2         = 'cornsilk'
# Primary menu items   / %s is the menu item and is required
THEME1         = '[COLOR '+COLOR1+'][B][I]([COLOR '+COLOR2+']Stream Life[/COLOR])[/B][/COLOR] [COLOR '+COLOR2+']%s[/COLOR][/I]'
# Build Names          / %s is the menu item and is required
THEME2         = '[COLOR '+COLOR2+']%s[/COLOR]'
# Alternate items      / %s is the menu item and is required
THEME3         = '[COLOR '+COLOR1+']%s[/COLOR]'
# Current Build Header / %s is the menu item and is required
THEME4         = '[COLOR '+COLOR1+']Current Build:[/COLOR] [COLOR '+COLOR2+']%s[/COLOR]'
# Current Theme Header / %s is the menu item and is required
THEME5         = '[COLOR '+COLOR1+']Current Theme:[/COLOR] [COLOR '+COLOR2+']%s[/COLOR]'

# Message for Contact Page
# Enable 'Contact' menu item 'Yes' hide or 'No' dont hide
HIDECONTACT    = 'No'
# You can add \n to do line breaks
CONTACT        = 'Thank you for choosing Stream Life\r\n\r\nAccess support, guides, tips, and other related services at\r\nwww.StreamLife.xyz'
#Images used for the contact window.  http:// for default icon and fanart
CONTACTICON    = 'http://streamlife.xyz/go/w1zard/Go_Android_Wizard/Images/Contact_Icon_256.png'
CONTACTFANART  = 'http://streamlife.xyz/go/w1zard/Go_Android_Wizard/Images/StreamLife_Fanart.jpg'
#########################################################

#########################################################
### AUTO UPDATE #########################################
########## FOR THOSE WITH NO REPO #######################
# Enable Auto Update 'Yes' or 'No'
AUTOUPDATE     = 'No'
# Url to wizard version
WIZARDFILE     = ''
#########################################################

#########################################################
### AUTO INSTALL ########################################
########## REPO IF NOT INSTALLED ########################
# Enable Auto Install 'Yes' or 'No'
AUTOINSTALL    = 'Yes'
# Addon ID for the repository
REPOID         = 'repository.streamlifegorepo'
# Url to Addons.xml file in your repo folder(this is so we can get the latest version)
REPOADDONXML   = 'http://streamlife.xyz/go/_r3po/addons.xml'
# Url to folder zip is located in
REPOZIPURL     = 'http://streamlife.xyz/go/_r3po/repository.streamlifegorepo/'
#########################################################

#########################################################
### NOTIFICATION WINDOW##################################
#########################################################
# Enable Notification screen Yes or No
ENABLE         = 'Yes'
# Url to notification file
NOTIFICATION   = 'http://streamlife.xyz/go/w1zard/Go_Android_Wizard/notify.txt'
# Use either 'Text' or 'Image'
HEADERTYPE     = 'Text'
HEADERMESSAGE  = 'New Message From Stream Life'
# url to image if using Image 424x180
HEADERIMAGE    = ''
# Background for Notification Window
BACKGROUND     = 'http://streamlife.xyz/go/w1zard/Go_Android_Wizard/Images/Notification_Background.jpg'
#########################################################